import { ChartIndicator, IChartIndicatorSettings, IChartIndicatorPrivate, IChartIndicatorEvents } from "./ChartIndicator";
import { CandlestickSeries } from "../../xy/series/CandlestickSeries";
import type { IIndicatorEditableSetting } from "./Indicator";
import type { Color } from "../../../core/util/Color";
export interface IHeikinAshiSettings extends IChartIndicatorSettings {
    /**
     * Increasing color.
     */
    increasingColor?: Color;
    /**
     * Decreasing color.
     */
    decreasingColor?: Color;
}
export interface IHeikinAshiPrivate extends IChartIndicatorPrivate {
}
export interface IHeikinAshiEvents extends IChartIndicatorEvents {
}
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export declare class HeikinAshi extends ChartIndicator {
    static className: string;
    static classNames: Array<string>;
    _settings: IHeikinAshiSettings;
    _privateSettings: IHeikinAshiPrivate;
    _events: IHeikinAshiEvents;
    /**
     * Indicator series.
     */
    series: CandlestickSeries;
    _editableSettings: IIndicatorEditableSetting[];
    _afterNew(): void;
    _createSeries(): CandlestickSeries;
    _updateChildren(): void;
    /**
     * @ignore
     */
    prepareData(): void;
}
//# sourceMappingURL=HeikinAshi.d.ts.map