import { ChartIndicator } from "./ChartIndicator";
import { LineSeries } from "../../xy/series/LineSeries";
import * as $array from "../../../core/util/Array";
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export class BullBearPower extends ChartIndicator {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_editableSettings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [{
                    key: "period",
                    name: this.root.language.translateAny("Period"),
                    type: "number"
                }, {
                    key: "seriesColor",
                    name: this.root.language.translateAny("Color"),
                    type: "color"
                }]
        });
    }
    _afterNew() {
        this._themeTags.push("bullbearpower");
        super._afterNew();
    }
    _createSeries() {
        return this.panel.series.push(LineSeries.new(this._root, {
            themeTags: ["indicator"],
            xAxis: this.xAxis,
            yAxis: this.yAxis,
            valueXField: "valueX",
            valueYField: "bbp",
            stroke: this.get("seriesColor"),
            fill: undefined
        }));
    }
    /**
     * @ignore
     */
    prepareData() {
        if (this.series) {
            const dataItems = this.get("stockSeries").dataItems;
            this.setRaw("field", "close");
            let i = 0;
            let data = this._getDataArray(dataItems);
            let period = this.get("period", 3);
            this._ema(data, period, "value_y", "ema");
            $array.each(dataItems, (dataItem) => {
                if (i >= period - 1) {
                    let close = dataItem.get("valueY");
                    if (close != null) {
                        let low = dataItem.get("lowValueY", close);
                        let high = dataItem.get("highValueY", close);
                        let ema = data[i].ema;
                        data[i].bbp = high - ema + low - ema;
                    }
                }
                i++;
            });
            this.series.data.setAll(data);
        }
    }
}
Object.defineProperty(BullBearPower, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "BullBearPower"
});
Object.defineProperty(BullBearPower, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: ChartIndicator.classNames.concat([BullBearPower.className])
});
//# sourceMappingURL=BullBearPower.js.map