import type { ISpritePointerEvent } from "../../../core/render/Sprite";
import type { DataItem } from "../../../core/render/Component";
import { Line } from "../../../core/render/Line";
import { DrawingSeries, IDrawingSeriesSettings, IDrawingSeriesPrivate, IDrawingSeriesDataItem } from "./DrawingSeries";
export interface IPolylineSeriesDataItem extends IDrawingSeriesDataItem {
}
export interface IPolylineSeriesSettings extends IDrawingSeriesSettings {
    /**
     * Show a closed color-filled shape instead of polyline.
     *
     * @default false
     * @since 5.9.0
     */
    fillShape?: boolean;
    /**
     * Number of pre-defined points in a shape.
     *
     * The shape will finish drawing once number is reached.
     * @since 5.9.0
     */
    pointCount?: number;
}
export interface IPolylineSeriesPrivate extends IDrawingSeriesPrivate {
}
/**
 * Draws a multi-point line (polyline).
 */
export declare class PolylineSeries extends DrawingSeries {
    static className: string;
    static classNames: Array<string>;
    _settings: IPolylineSeriesSettings;
    _privateSettings: IPolylineSeriesPrivate;
    _dataItemSettings: IPolylineSeriesDataItem;
    protected _tag: string;
    protected _drawingLine: Line;
    _prepareChildren(): void;
    protected _handlePointerClick(event: ISpritePointerEvent): void;
    protected _setContextSprite(context: any): void;
    disableDrawing(): void;
    clearDrawings(): void;
    protected _addPoint(event: ISpritePointerEvent, closing?: boolean): void;
    protected _endPolyline(dataItem?: DataItem<this["_dataItemSettings"]>): void;
    protected _dispatchAdded(): void;
    protected _handlePointerMove(event: ISpritePointerEvent): void;
    protected _updateElements(): void;
    /**
     * Cancels current drawing
     *
     * @since 5.9.0
     */
    cancelDrawing(): void;
}
//# sourceMappingURL=PolylineSeries.d.ts.map