import type { ISpritePointerEvent } from "../../../core/render/Sprite";
import type { Container } from "../../../core/render/Container";
import type { DataItem } from "../../../core/render/Component";
import type { SpriteResizer } from "../../../core/render/SpriteResizer";
import type { Graphics } from "../../../core/render/Graphics";
import { PolylineSeries, IPolylineSeriesSettings, IPolylineSeriesPrivate, IPolylineSeriesDataItem } from "./PolylineSeries";
import { EditableLabel } from "../../../core/render/EditableLabel";
import type { Color } from "../../../core/util/Color";
import { Template } from "../../../core/util/Template";
export interface ILabelSeriesDataItem extends IPolylineSeriesDataItem {
}
export interface ILabelSeriesSettings extends IPolylineSeriesSettings {
    /**
     * Label font size.
     */
    labelFontSize?: number | string | undefined;
    /**
     * Label font damily.
     */
    labelFontFamily?: string;
    /**
     * Font weight.
     */
    labelFontWeight?: "normal" | "bold" | "bolder" | "lighter" | "100" | "200" | "300" | "400" | "500" | "600" | "700" | "800" | "900";
    /**
     * Font style.
     */
    labelFontStyle?: "normal" | "italic" | "oblique";
    /**
     * Label color.
     */
    labelFill?: Color;
}
export interface ILabelSeriesPrivate extends IPolylineSeriesPrivate {
    inputContainer: HTMLDivElement;
    input: HTMLTextAreaElement;
    label: EditableLabel;
}
export declare class LabelSeries extends PolylineSeries {
    static className: string;
    static classNames: Array<string>;
    _settings: ILabelSeriesSettings;
    _privateSettings: ILabelSeriesPrivate;
    _dataItemSettings: ILabelSeriesDataItem;
    spriteResizer: SpriteResizer;
    protected _tag: string;
    protected _isEditing: boolean;
    protected _isSelected: boolean;
    protected _afterNew(): void;
    protected _dispatchAdded(): void;
    protected _setContextSprite(_context: any): void;
    protected _tweakBullet(container: Container, dataItem: DataItem<ILabelSeriesDataItem>): void;
    protected _tweakBullet2(_label: EditableLabel, _dataItem: DataItem<ILabelSeriesDataItem>): void;
    protected _handlePointerClick(event: ISpritePointerEvent): void;
    protected _afterTextSave(_dataContext: any): void;
    protected _getLabelTemplate(): Template<any>;
    disposeDataItem(dataItem: DataItem<this["_dataItemSettings"]>): void;
    protected _hideAllBullets(): void;
    protected _updateSelector(selector: Graphics, index: number): void;
    _prepareChildren(): void;
    protected _applySettings(index: number, settings?: {
        [index: string]: any;
    }): void;
    protected _handleBulletDragStart(event: ISpritePointerEvent): void;
    protected _handleBulletDragStop(event: ISpritePointerEvent): void;
    toggleDrawing(enabled?: boolean): void;
}
//# sourceMappingURL=LabelSeries.d.ts.map