import type { IHierarchyDataItem } from "./Hierarchy";
import type { DataItem } from "../../core/render/Component";
import type { Bullet } from "../../core/render/Bullet";
import type { Root } from "../../core/Root";
import type { List } from "../../core/util/List";
import type { LinkedHierarchy } from "./LinkedHierarchy";
import { Graphics, IGraphicsSettings, IGraphicsPrivate } from "../../core/render/Graphics";
export interface IHierarchyLinkSettings extends IGraphicsSettings {
    /**
     * Source node data item.
     */
    source?: DataItem<IHierarchyDataItem>;
    /**
     * Target node data item.
     */
    target?: DataItem<IHierarchyDataItem>;
    /**
     * Strength of the link.
     */
    strength?: number;
    /**
     * Distance in pixels.
     */
    distance?: number;
}
export interface IHierarchyLinkPrivate extends IGraphicsPrivate {
    d3Link: any;
}
/**
 * Draws a link between nodes in a hierarchy series.
 */
export declare class HierarchyLink extends Graphics {
    _settings: IHierarchyLinkSettings;
    _privateSettings: IHierarchyLinkPrivate;
    static className: string;
    static classNames: Array<string>;
    bullets: Array<Bullet>;
    series?: LinkedHierarchy;
    _handleBullets(bullets: List<(<D extends DataItem<IHierarchyDataItem>>(root: Root, source: D, target: D) => Bullet | undefined)>): void;
    _changed(): void;
    hide(duration?: number): Promise<void>;
    show(duration?: number): Promise<void>;
    _beforeChanged(): void;
    protected _dispose(): void;
}
//# sourceMappingURL=HierarchyLink.d.ts.map