import { DateAxis } from "../xy/axes/DateAxis";
/**
 * A date axis that is used as an X (horizontal) axis for [[Gantt]] charts.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/gantt/#Timeline_horizontal_axis} for more info
 * @since 5.14.0
 * @important
 */
export class GanttDateAxis extends DateAxis {
    constructor() {
        super(...arguments);
        /**
         * A reference to the parent [[Gantt]] chart.
         */
        Object.defineProperty(this, "gantt", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
}
Object.defineProperty(GanttDateAxis, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "GanttDateAxis"
});
Object.defineProperty(GanttDateAxis, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: DateAxis.classNames.concat([GanttDateAxis.className])
});
//# sourceMappingURL=GanttDateAxis.js.map