import type { GanttCategoryAxis, IGanttCategoryAxisDataItem } from "./GanttCategoryAxis";
import type { AxisLabel } from "../xy/axes/AxisLabel";
import type { AxisTick } from "../xy/axes/AxisTick";
import { AxisRendererY, IAxisRendererYSettings, IAxisRendererYPrivate } from "../xy/axes/AxisRendererY";
import { ListTemplate } from "../../core/util/List";
import { EditableAxisLabel } from "../xy/axes/EditableAxisLabel";
import { Button, Container, DataItem, Rectangle } from "../../..";
import { ProgressPie } from "../../core/render/ProgressPie";
import { NumericStepper } from "../../core/render/NumericStepper";
export interface IGanttCategoryAxisRendererSettings extends IAxisRendererYSettings {
}
export interface IGanttCategoryAxisRendererPrivate extends IAxisRendererYPrivate {
}
/**
 * Renderer for [[GanttCategoryAxis]] axes.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/gantt/#Category_vertical_axis} for more info
 * @since 5.14.0
 * @important
 */
export declare class GanttCategoryAxisRenderer extends AxisRendererY {
    static className: string;
    static classNames: Array<string>;
    _settings: IGanttCategoryAxisRendererSettings;
    _privateSettings: IGanttCategoryAxisRendererPrivate;
    axis: GanttCategoryAxis<this>;
    /**
     * A [[TemplateList]] with all the labels attached to the axis.
     *
     * `labels.template` can be used to configure appearance of the labels.
     *
     * @default new ListTemplate<AxisLabelRadial>
     */
    readonly labels: ListTemplate<EditableAxisLabel>;
    /**
     * A [[TemplateList]] with all the containers attached to the axis.
     *
     * This container holds all the elements of axis item - label, grip, task bullet, controls, etc.
     *
     * @default new ListTemplate<Container>
     */
    readonly containers: ListTemplate<Container>;
    /**
     * A [[TemplateList]] with all the controls containers attached to the axis.
     *
     * This container holds all the controls of axis item - duration stepper, progress pie, etc.
     *
     * @default new ListTemplate<Container>
     */
    readonly controlsContainers: ListTemplate<Container>;
    /**
     * A [[TemplateList]] with all the grips attached to the axis.
     *
     * Dragging by the grips allows to rearrange the axis items.
     *
     * @default new ListTemplate<Rectangle>
     */
    readonly grips: ListTemplate<Rectangle>;
    /**
     * A [[TemplateList]] with all the progress pies attached to the axis.
     *
     * Progress pies are used to show progress of tasks.
     *
     * @default new ListTemplate<ProgressPie>
     */
    readonly progressPies: ListTemplate<ProgressPie>;
    /**
     * A [[TemplateList]] with all the task bullets attached to the axis.
     *
     * Task bullets are shown to the left of the label. If a task doesn't have
     * children it will show circle. Otherwise it will show rectangle which is
     * clickable and can be used to toggle collapse/expand of the task.
     *
     * @default new ListTemplate<Button>
     */
    readonly taskBullets: ListTemplate<Button>;
    /**
     * A [[TemplateList]] with all the duration steppers attached to the axis.
     *
     * Duration steppers are used to set and show duration of tasks.
     *
     * @default new ListTemplate<NumericStepper>
     */
    readonly durationSteppers: ListTemplate<NumericStepper>;
    /**
     * @ignore
     */
    makeLabel(dataItem: DataItem<IGanttCategoryAxisDataItem>, themeTags: Array<string>): AxisLabel;
    /**
     * @ignore
     */
    updateLabel(label?: AxisLabel, position?: number, endPosition?: number): void;
    /**
     * @ignore
     */
    updateTick(tick?: AxisTick, position?: number, endPosition?: number, count?: number): void;
}
//# sourceMappingURL=GanttCategoryAxisRenderer.d.ts.map